﻿''' <summary>
'''用于获取用户输入以设置记录的时间和信道的窗体。
''' 
''' </summary>
''' <remarks></remarks>
Public Class SetRecording
    Private recorderValue As Recorder
    Public Property Recorder() As Recorder
        Get
            Return recorderValue
        End Get
        Set(ByVal value As Recorder)
            recorderValue = value
        End Set
    End Property

    Private Sub cmdCancel_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdCancel.Click
        '卸载窗体，释放引用。
        Me.Close()
    End Sub

    Private Sub cmdOK_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdOK.Click
        Dim isOK As Boolean '返回值
        Dim channel As Integer '信道号
        Dim message As String '消息文本

        '调用函数以验证该项
        isOK = ValidateTime(txtStart.Text, txtStart)
        '如果该项无效，则离开此处
        If isOK = False Then Exit Sub

        '调用函数以验证该项
        isOK = ValidateTime(txtEnd.Text, txtEnd)
        '如果该项无效，则离开此处
        If isOK = False Then Exit Sub

        '读取信道显示的值。
        channel = CInt(txtChannel.Text)

        '如果不在范围内，则向用户发出警告。
        If channel < 2 Or channel > 13 Then
            message = "Channel must be between 2 and 13!"
            MsgBox(message, MsgBoxStyle.OKOnly, "Invalid Channel")
            txtChannel.Focus()
            Exit Sub
        End If

        '设置 Recorder 类的属性。
        '将属性设为大写形式，以便于以后的比较。
        Recorder.StartTime = CDate(txtStart.Text)
        Recorder.StopTime = CDate(txtEnd.Text)
        recorder.Channel = channel

        '卸载窗体，释放引用。
        Me.Close()
    End Sub

    Private Sub frmSetTime_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        txtStart.Text = CStr(Recorder.StartTime)
        txtEnd.Text = CStr(Recorder.StopTime)
        txtChannel.Text = CStr(Recorder.Channel)
    End Sub

    Private Sub txtChannel_Enter(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles txtChannel.Enter
        '选择现有文本。
        txtChannel.SelectAll()
    End Sub

    Private Sub txtChannel_KeyPress(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.KeyPressEventArgs) Handles txtChannel.KeyPress
        Dim KeyAscii As Integer = Asc(eventArgs.KeyChar)
        '使用 IsNumeric 函数以确保
        '仅输入数字。
        If Not IsNumeric(Chr(KeyAscii)) Then
            '不是数字，因此设置为 null。
            KeyAscii = 0
        End If
        If KeyAscii = 0 Then
            eventArgs.Handled = True
        End If
    End Sub

    Private Sub txtEnd_Enter(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles txtEnd.Enter
        '选择现有文本。
        txtEnd.SelectAll()
    End Sub

    Private Sub txtEnd_Leave(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles txtEnd.Leave
        Dim isOK As Boolean '返回值
        '调用函数以验证该项
        isOK = ValidateTime(txtEnd.Text, txtEnd)
    End Sub

    Private Sub txtStart_Enter(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles txtStart.Enter
        '选择现有文本
        txtStart.SelectAll()
    End Sub

    Private Sub txtStart_Leave(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles txtStart.Leave
        Dim isOK As Boolean
        '调用函数以验证该项
        isOK = ValidateTime(txtStart.Text, txtStart)
    End Sub

    ''' <summary>
    '''验证用户输入的
    '''时间字符串。如果正确，则设置该
    '''字符串格式；如果不正确，则显示一条消息。
    ''' </summary>
    ''' <param name="Time">从文本框传递的字符串。</param>
    ''' <param name="Field">文本框控件的名称。</param>
    ''' <returns>如果字符串是有效的时间，则为 True；
    '''否则为 False。</returns>
    ''' <remarks></remarks>
    Function ValidateTime(ByRef Time As String, ByRef Field As System.Windows.Forms.TextBox) As Boolean
        Dim message As String

        'IsDate 函数验证时间的有效性
        If IsDate(Time) Then
            '设置字符串格式并返回 True
            Field.Text = String.Format(Time, "h:mm AM/PM")
            ValidateTime = True
        Else
            '将错误通知给用户
            message = "Please enter a valid time! "
            message = message & "(Hour:Minute AM/PM)"
            MsgBox(message, MsgBoxStyle.OKOnly, "Invalid Time")

            '将焦点返回文本框
            Field.Focus()

            '返回 False 值
            ValidateTime = False
        End If
    End Function

End Class